<?php

namespace App\Http\Controllers\owner;

use Illuminate\Session\Store;
use Illuminate\Http\Request;



use App\Http\Controllers\Controller;
use App\Http\Controllers\owner\OwnerBaseController;
use App\Providers\RouteServiceProvider;
//use App\User;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Auth;

use App\Models\Owner;

class OwnerController extends OwnerBaseController
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
     use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::OWNERHOME;
    
    public function __construct(Store $session){
        parent::__construct($session);
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return view('owner.register');
    }
    
    
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\User
     */
    protected function register_submit(Request $request)
    {
        $user =  Owner::create([
            'name' => $request['name'],
            'email' => $request['email'],
            'password' => Hash::make($request['password']),
        ]);
        Auth::login($user);
//         if(Auth::login($user))   {
//   return redirect('owner/dashboard')->with('success','School added successfully!');
//         }
        return redirect('owner/dashboard')->with('success','School added successfully!');
    }
    
    
    public function login()
    {
        dd('loginnnnnnnnnnn');
        return view('home');
    }
}
